import math
import matplotlib.pyplot as plt
import matplotlib.animation as animation
import matplotlib.backends.backend_tkagg as bt
import tkinter as tk

a, f = 5, 3
num, delta_t = 100, 0.01
t, y = [], []

root = tk.Tk()
root.title('Real-Time Sine Wave Plot With Blitting')
root.geometry('800x600')

def stop():

    ani.pause()

    return

btn = tk.Button(root, text='Stop Plot', command=stop)
btn.pack()

fig, ax = plt.subplots(layout='constrained')
line, = plt.plot(t, y, marker='o')
canvas = bt.FigureCanvasTkAgg(fig, root)
canvas.get_tk_widget().pack()

def init():

    ax.set_xlim(0, (num-1)*delta_t)
    ax.set_ylim(-a, a)
    ax.set_xlabel('Time (s)')
    ax.set_ylabel('Sine-Wave Displacement (cm)')

    return line,

def animate(i, t, y):

    t_i = i*delta_t
    y_i = a * math.sin(2.0*math.pi*f*t_i)

    t.append(t_i)
    y.append(y_i)

    line.set_data(t, y)

    return line,

ani = animation.FuncAnimation(fig, animate, frames=num,
                              fargs=(t, y), interval=100,
                              init_func=init, repeat=False,
                              blit=True)

canvas.draw()

root.mainloop()

